<?php

class IdentityNumberValidator extends CValidator
{
	public $disableChecksum = false;

	protected function validateAttribute($object, $attribute)
	{
		$value = trim($object->$attribute);

		if (empty($value)) return;

		static $weights = array(1, 9, 3, 7, 1, 9, 3, 1, 9);

		if (!preg_match('/^[A-Z]{3}[0-9]{6}$/', $value))
		{
			$this->addError($object, $attribute, Yii::t('SerialNumberValidator','Pole attribute jest nieprawidłowe.'), array(
				'attribute' => $object->getAttributeLabel($attribute)
			));
			return;
		}

		if ($this->disableChecksum)
			return;

		$sum = 0;
		$values = str_split($value);
		foreach ($weights as $i => $val)
		{
			$x = ord($values[$i]);
			if ($x >= ord('A') && $x <= ord('Z'))
				$x = $x - ord('A') + 10;
			else
				$x = $x - ord('0');
			$sum += $x * (int)$val;
		}
		$sum %= 10;

		if ($sum !== 0)
			$this->addError($object, $attribute, Yii::t('SerialNumberValidator','Pole attribute ma niepoprawną sumę kontrolną.'), array(
				'attribute' => $object->getAttributeLabel($attribute)
			));
	}
}
